/*
        FilterScript

        Author:         malaka | http://forum.sa-mp.com/member.php?u=112277
        URL:            http://forum.sa-mp.com/showthread.php?p=2002621
        Name:           Simple FS to show flags
        Version:        Float:3.0
        Desc:           Shows a flag for all player on the server
        License:        CC BY-NC | http://creativecommons.org/licenses/by-nc/3.0/

        Credits:
        * SA-MP Team
        * Creater of zcmd - Zeex (http://forum.sa-mp.com/showthread.php?t=91354)
*/

// Includes
#include <a_samp>
#include <zcmd>

// Defines
#define DIALOG_FLAGS            7337
#define FLAGS_DISPLAY_TIME      1000 * 5 // Flag will be shown for 5 seconds

// Global variables
new Text:TDFlag;

enum FDCountry
{
        Name[25],
        String[160]
}
new CountryNames[][FDCountry] =
{
        {"Afghanistan","~l~]]]~r~]]]~g~]]]~n~~l~]]]~r~]]]~g~]]]~n~~l~]]]~r~]]]~g~]]]~n~~l~]]]~r~]]]~g~]]]~n~~l~]]]~r~]]]~g~]]]~n~~l~]]]~r~]]]~g~]]]"},
        {"Algeria","~g~]]]]~w~]]]]~n~~g~]]]]~w~]]]]~n~~g~]]]]~w~]]]]~n~~g~]]]]~w~]]]]~n~~g~]]]]~w~]]]]~n~~g~]]]]~w~]]]]"},
        {"Andorra","~b~]]]~y~]]]~r~]]]~n~~b~]]]~y~]]]~r~]]]~n~~b~]]]~y~]]]~r~]]]~n~~b~]]]~y~]]]~r~]]]~n~~b~]]]~y~]]]~r~]]]~n~~b~]]]~y~]]]~r~]]]"},
        {"Angola","~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~l~]]]]]]]]]~n~~l~]]]]]]]]]~n~~l~]]]]]]]]]"},
        {"Argentina","~b~~h~~h~]]]]]]]]]~n~~b~~h~~h~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~b~~h~~h~]]]]]]]]]~n~~b~~h~~h~]]]]]]]]]"},
        {"Austria","~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]"},
        {"Azerbaijan","~b~~h~]]]]]]]]]~n~~b~~h~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~g~~h~]]]]]]]]]~n~~g~~h~]]]]]]]]]"},
        {"Belgium","~l~]]]~y~]]]~r~]]]~n~~l~]]]~y~]]]~r~]]]~n~~l~]]]~y~]]]~r~]]]~n~~l~]]]~y~]]]~r~]]]~n~~l~]]]~y~]]]~r~]]]"},
        {"Bosnia and Herzegovina","~b~]]~w~]~y~]]]]~b~]]~n~~b~]]]~w~]~y~]]]~b~]]~n~~b~]]]]~w~]~y~]]~b~]]~n~~b~]]]]]~w~]~y~]~b~]]"},
        {"Bulgaria","~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~g~]]]]]]]]]~n~~g~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]"},
        {"Canada","~r~]]]~w~]]]]]~r~]]]~n~~r~]]]~w~]]~r~]~w~]]~r~]]]~n~~r~]]]~w~]~r~]]]~w~]~r~]]]~n~~r~]]]~w~]]~r~]~w~]]~r~]]]~n~~r~]]]~w~]]~r~]~w~]]~r~]]]~n~~r~]]]~w~]]]]]~r~]]]"},
        {"Czech","~b~]~w~]]]]]]]]~n~~b~]]~w~]]]]]]]~n~~b~]]~r~]]]]]]]~n~~b~]~r~]]]]]]]]"},
        {"Denmark","~r~]]]~w~]]~r~]]]]]~n~~r~]]]~w~]]~r~]]]]]~n~~w~]]]]]]]]]]~n~~r~]]]~w~]]~r~]]]]]~n~~r~]]]~w~]]~r~]]]]]"},
        {"Egypt","~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~l~]]]]]]]]]~n~~l~]]]]]]]]]"},
        {"England","~w~]]]]~r~]~w~]]]]~n~~w~]]]]~r~]~w~]]]]~n~~r~]]]]]]]]]~n~~w~]]]]~r~]~w~]]]]~n~~w~]]]]~r~]~w~]]]]"},
        {"Estonia","~b~~h~]]]]]]]]]~n~~b~~h~]]]]]]]]]~n~~l~]]]]]]]]]~n~~l~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]"},
        {"Ethiopia","~g~]]]]]]]]]~n~~g~]]]]]]]]]~n~~y~]]]]]]]]]~n~~y~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]"},
        {"Finland","~w~]]]~b~]]~w~]]]]]~n~~w~]]]~b~]]~w~]]]]]~n~~b~]]]]]]]]]]~n~~w~]]]~b~]]~w~]]]]]~n~~w~]]]~b~]]~w~]]]]]"},
        {"France","~b~]]]~w~]]]~r~]]]~n~~b~]]]~w~]]]~r~]]]~n~~b~]]]~w~]]]~r~]]]~n~~b~]]]~w~]]]~r~]]]~n~~b~]]]~w~]]]~r~]]]"},
        {"Georgia","~w~]~r~]~w~]]~r~]~w~]]~r~]~w~]~n~~w~]]]]~r~]~w~]]]]~n~~r~]]]]]]]]]~n~~w~]]]]~r~]~w~]]]]~n~~w~]~r~]~w~]]~r~]~w~]]~r~]~w~]"},
        {"Germany","~l~]]]]]]]]]~n~~l~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~y~]]]]]]]]]~n~~y~]]]]]]]]]"},
        {"Greece","~b~]]]]]]]]]~n~~w~]]]]]]]]]~n~~b~]]]]]]]]]~n~~w~]]]]]]]]]~n~~b~]]]]]]]]]~n~~w~]]]]]]]]]~n~~b~]]]]]]]]]"},
        {"Hungary","~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~g~]]]]]]]]]~n~~g~]]]]]]]]]"},
        {"Israel","~b~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~b~]]]]]]]]]"},
        {"Italy","~g~]]]~w~]]]~r~]]]~n~~g~]]]~w~]]]~r~]]]~n~~g~]]]~w~]]]~r~]]]~n~~g~]]]~w~]]]~r~]]]~n~~g~]]]~w~]]]~r~]]]"},
        {"Latvia","~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~w~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]"},
        {"Lithuania","~y~]]]]]]]]]~n~~y~]]]]]]]]]~n~~g~]]]]]]]]]~n~~g~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]"},
        {"Luxembourg","~r~~h~]]]]]]]]]~n~~r~~h~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~b~~h~]]]]]]]]]~n~~b~~h~]]]]]]]]]"},
        {"Malta","~w~]]]]~r~]]]]~n~~w~]]]]~r~]]]]~n~~w~]]]]~r~]]]]~n~~w~]]]]~r~]]]]"},
        {"Monaco","~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~"},
        {"Netherlands","~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~b~]]]]]]]]]~n~~b~]]]]]]]]]"},
        {"Philippines","~w~]~b~]]]]]]]]~n~~w~]]~b~]]]]]]]~n~~w~]]~r~]]]]]]]~n~~w~]~r~]]]]]]]]"},
        {"Poland","~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]"},
        {"Portugal","~g~]]]~r~]]]]]~n~~g~]]]~r~]]]]]~n~~g~]]]~r~]]]]]~n~~g~]]]~r~]]]]]"},
        {"Romania","~b~]]]~y~]]]~r~]]]~n~~b~]]]~y~]]]~r~]]]~n~~b~]]]~y~]]]~r~]]]~n~~b~]]]~y~]]]~r~]]]~n~~b~]]]~y~]]]~r~]]]"},
        {"Russia","~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~b~]]]]]]]]]~n~~b~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]"},
        {"San Marino","~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~w~]]]]]]]]]~n~~b~~h~~h~]]]]]]]]]~n~~b~~h~~h~]]]]]]]]]~n~~b~~h~~h~]]]]]]]]]~n~"},
        {"Spain","~r~]]]]]]]]]~n~~r~]]]]]]]]]~n~~y~]]]]]]]]]~n~~y~]]]]]]]]]~n~~r~]]]]]]]]]~n~~r~]]]]]]]]]"},
        {"Sweden","~b~]]]~y~]]~b~]]]]]~n~~b~]]]~y~]]~b~]]]]]~n~~y~]]]]]]]]]]~n~~b~]]]~y~]]~b~]]]]]~n~~b~]]]~y~]]~b~]]]]]"},
        {"Switzerland","~r~]]]]]~n~~r~]]~w~]~r~]]~n~~r~]~w~]]]~r~]~n~~r~]]~w~]~r~]]~n~~r~]]]]]~n~"},
        {"Turkey", "~r~]]]]]]]]~n~~r~]]~w~]]~r~]]]]~n~~r~]~w~]~r~]]]~w~]~r~]]~n~~r~]]~w~]]~r~]]]]~n~~r~]]]]]]]]"},
        {"U.S.","~b~]]]~r~]]]]]]~n~~b~]]]~w~]]]]]]~n~~b~]]]~r~]]]]]]~n~~w~]]]]]]]]]~n~~r~]]]]]]]]]"},
        {"Ukraine","~b~]]]]]]]]]~n~~b~]]]]]]]]]~n~~b~]]]]]]]]]~n~~y~]]]]]]]]]~n~~y~]]]]]]]]]~n~~y~]]]]]]]]]"},
        {"Vatican City","~y~]]]]~w~]]]]~n~~y~]]]]~w~]]]]~n~~y~]]]]~w~]]]]~n~~y~]]]]~w~]]]]~n~~y~]]]]~w~]]]]~n~~y~]]]]~w~]]]]~n~~y~]]]]~w~]]]]~n~~y~]]]]~w~]]]]"}
};

public OnFilterScriptInit()
{
        TDFlag = TextDrawCreate(265.000000, 165.000000, "_");
        TextDrawBackgroundColor(TDFlag, 255);
        TextDrawFont(TDFlag, 2);
        TextDrawLetterSize(TDFlag, 0.350000, 1.299999);
        TextDrawColor(TDFlag, -1);
        TextDrawSetOutline(TDFlag, 1);
        TextDrawSetProportional(TDFlag, 1);
}

public OnFilterScriptExit()
{
        TextDrawHideForAll(TDFlag);
        TextDrawDestroy(TDFlag);
}

/* /flags command which is only accessable by RCON-Admins, feel free to change it to your own Admin System */
COMMAND:flags(playerid,params[])
{
        new
                CountryList[2000];

        for (new i = 0; i < sizeof(CountryNames); i++) {
                format(CountryList, sizeof(CountryList),"%s%s\n",CountryList,CountryNames[i][Name]);
        }

        if (IsPlayerAdmin(playerid)) ShowPlayerDialog(playerid,DIALOG_FLAGS,DIALOG_STYLE_LIST,"Select Country:",CountryList,"Select","Close");
        else
                return 0;

        return 1;
}

public OnDialogResponse(playerid, dialogid, response, listitem, inputtext[])
{
        if (dialogid == DIALOG_FLAGS) {
                if(!response) return 1;

                new
                        FLAGS_DISPLAY_TEXT[256];

                if (strlen(CountryNames[listitem][Name]) > 3 && strlen(CountryNames[listitem][String]) > 5)
                {
                        format(FLAGS_DISPLAY_TEXT, sizeof(FLAGS_DISPLAY_TEXT), "%s~n~~n~~w~%s",CountryNames[listitem][String],CountryNames[listitem][Name]);
                        TextDrawSetString(TDFlag,FLAGS_DISPLAY_TEXT);
                        TextDrawShowForAll(TDFlag);
                        SetTimer("DestroyTDFlag",FLAGS_DISPLAY_TIME,false);
                } else {
                        SendClientMessage(playerid,0xDCDCDCFF, "Invalid Selection");
                }
        }

        return 1;
}

forward DestroyTDFlag();
public DestroyTDFlag()
{
        TextDrawHideForAll(TDFlag);
}
